/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.Message;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;
import org.simplejavamail.email.Recipient;
import org.simplejavamail.internal.util.Preconditions;

public final class MiscUtil {
    private static final Pattern MATCH_INSIDE_CIDBRACKETS = Pattern.compile("<?([^>]*)>?");
    private static final Pattern COMMA_DELIMITER_PATTERN = Pattern.compile("(@.*?>?)\\s*[,;]");
    private static final Pattern TRAILING_TOKEN_DELIMITER_PATTERN = Pattern.compile("<\\|>$");
    private static final Pattern TOKEN_DELIMITER_PATTERN = Pattern.compile("\\s*<\\|>\\s*");

    public static <T> T checkNotNull(T value, String msg) {
        if (value == null) {
            throw new NullPointerException(msg);
        }
        return value;
    }

    public static <T> T checkArgumentNotEmpty(T value, String msg) {
        if (MiscUtil.valueNullOrEmpty(value)) {
            throw new IllegalArgumentException(msg);
        }
        return value;
    }

    public static <T> boolean valueNullOrEmpty(T value) {
        return value == null || value instanceof String && ((String)value).isEmpty() || value instanceof Collection && ((Collection)value).isEmpty() || value instanceof byte[] && ((byte[])value).length == 0;
    }

    public static String buildLogString(byte[] bytes, boolean isReceived) {
        StringBuilder debugMsg = new StringBuilder();
        debugMsg.append(isReceived ? "Received: " : "Sent: ");
        for (byte aByte : bytes) {
            debugMsg.append(Integer.toHexString(MiscUtil.toInt(aByte))).append(" ");
        }
        return debugMsg.toString();
    }

    public static int toInt(byte b) {
        return b & 0xFF;
    }

    public static String encodeText(@Nullable String name) {
        if (name == null) {
            return null;
        }
        try {
            return MimeUtility.encodeText((String)name);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Nullable
    public static String extractCID(@Nullable String cid) {
        return cid != null ? MATCH_INSIDE_CIDBRACKETS.matcher(cid).replaceAll("$1") : null;
    }

    @Nonnull
    public static String readInputStreamToString(@Nonnull InputStream inputStream, @Nonnull Charset charset) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int result = bufferedInputStream.read();
        while (result != -1) {
            byteArrayOutputStream.write((byte)result);
            result = bufferedInputStream.read();
        }
        return byteArrayOutputStream.toString(Preconditions.checkNonEmptyArgument(charset, "charset").name());
    }

    @Nonnull
    public static String[] extractEmailAddresses(@Nonnull String emailAddressList) {
        Preconditions.checkNonEmptyArgument(emailAddressList, "emailAddressList");
        String unambiguousDelimitedList = COMMA_DELIMITER_PATTERN.matcher(emailAddressList).replaceAll("$1<|>");
        String withoutTrailingDelimeter = TRAILING_TOKEN_DELIMITER_PATTERN.matcher(unambiguousDelimitedList).replaceAll("");
        return TOKEN_DELIMITER_PATTERN.split(withoutTrailingDelimeter, 0);
    }

    @Nonnull
    public static Recipient interpretRecipient(@Nullable String name, boolean fixedName, @Nonnull String emailAddress, @Nullable Message.RecipientType type) {
        try {
            InternetAddress parsedAddress = InternetAddress.parse((String)emailAddress, (boolean)false)[0];
            String relevantName = fixedName || parsedAddress.getPersonal() == null ? MiscUtil.defaultTo(name, parsedAddress.getPersonal()) : MiscUtil.defaultTo(parsedAddress.getPersonal(), name);
            return new Recipient(relevantName, parsedAddress.getAddress(), type);
        }
        catch (AddressException e) {
            return new Recipient(name, emailAddress, type);
        }
    }

    @Nullable
    public static <T> T defaultTo(@Nullable T value, @Nullable T defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static boolean classAvailable(@Nonnull String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Nullable
    public static String normalizeNewlines(@Nullable String text) {
        return text == null ? null : text.replaceAll("\\r\\n", "\n").replaceAll("\\r", "\n");
    }
}

